/*
 * QrfeReaderInterfaceGlobal.h
 *
 *  Created on: 25.11.2009
 *      Author: stefan.detter
 */

#ifndef QRFEREADERINTERFACEGLOBAL_H_
#define QRFEREADERINTERFACEGLOBAL_H_

#include <QObject>
#include <QString>
#include <QMap>

#include <QMetaType>

#include <QrfeGlobal>
#include <QrfeProtocolHandlerGlobal>

namespace QrfeGlobal
{
	Q_ENUMS(ReaderType TagType ReaderModule HandlerState HandlerAction TMIResult)

	typedef enum {
		TYPE_PASSIVE,
		TYPE_UNKOWN
	} ReaderType;

	typedef enum{
		TAG_ISO6B,
		TAG_GEN2,
		TAG_GEN2_NXP_READPROTECTED,
		TAG_UNKWON
	} TagType;
	QString tagTypeToString(const TagType t);

	typedef enum {
		VERSION_RFE_PUR_RM1,
		VERSION_RFE_PUR_RM2,
	} ReaderModule;
	QString readerModuleToString(const ReaderModule rm);

	typedef enum  {
		STATE_ONLINE,
		STATE_OFFLINE,
		STATE_RESTARTING,
		STATE_NOTRESPONDING,
		STATE_UNKOWN_ERROR
	} HandlerState;
	QString stateToString(const HandlerState state);

	typedef enum  {
		ACTION_OFFLINE,
		ACTION_IDLE,
		ACTION_SCANNING,
		ACTION_WAITING
	} HandlerAction;
	QString actionToString(const HandlerAction action);

	typedef enum {
		TMI_OK,
		TMI_ERROR,
		TMI_COMMERROR,
		TMI_NORESPONSE,
		TMI_NA,
		TMI_TAG_UNREACHABLE,
		TMI_MEM_OVERRUN,
		TMI_MEM_LOCKED,
		TMI_INSUFFICIENT_POWER,
		TMI_WRONG_PASSW,
	} TMIResult;

	typedef enum {
		EEPROM_AVAILABLE			= 0x00000001,
		PLUG_OFF_REQUIRED			= 0x00000002,
		UPDATE_DIALOG				= 0x00010000,
		READER_SETTINGS				= 0x00020000,
		APPLICATION_SETTINGS		= 0x00040000,
		ENGINEERING					= 0x00080000,
	} ReaderCaps;

	typedef enum {
		READ_FROM_TAG				= 0x00000001,
		WRITE_TO_TAG				= 0x00000002,
		LOCK_TAG					= 0x00000004,
		KILL_TAG					= 0x00000008,
		READ_MULTIPLE_FROM_TAG		= 0x00000010,
		NXP_SET_READ_PROTECT		= 0x00010000,
		NXP_RESET_READ_PROTECT		= 0x00020000,
		NXP_SEND_CMD_TO_CONTOLER	= 0x00040000,
	} TagFunctionCaps;

//	typedef enum {
//		FREQUENCY_SETTINGS			= 0x00000001,
//		ANTENNA_POWER_SETTING		= 0x00000002,
//		ATTENUATION_SETTING			= 0x00000004,
//		SENSITIVITY_SETTINGS		= 0x00000008,
//		INVENTORY_MODE_SETTINGS		= 0x00010000,
//		POWER_SAFE_SETTINGS			= 0x00020000,
//		RSSI_SETTINGS				= 0x00040000,
//		TAG_HANDLER_SETTINGS		= 0x00080000,
//		GEN2_LINKFREQ_SETTINGS		= 0x00100000,
//		GEN2_CODING_SETTINGS		= 0x00200000,
//		MODULATION_DEPTH_SETTINGS	= 0x00400000,
//	} ReaderSettingsCaps;
//
//	typedef enum {
//		REFLECTED_POWER_MEASUREMENT	= 0x00000001,
//		RSSI_MEASUREMENT			= 0x00000002,
//		AS399X_REGISTER_READ		= 0x00000004,
//	} ReaderEngineeringCaps;

	typedef enum {
		AUR_APP_STANDARD 				= 0x00000001,
		AUR_APP_TAG 					= 0x00000002,
		AUR_APP_DIRECT_MODE 			= 0x00000003,
		AUR_APP_WLAN_CONTROL 			= 0x00000004,
		AUR_APP_HYCAT 					= 0x00000005,
	}AurApplications;

	typedef enum {
		PUR_APP_STANDARD 				= 0x00000001,
		PUR_APP_HID_KEYBOARD			= 0x00000014,
        PUR_APP_IDTRONIC_RUSSIA			= 0x00000018,
    } PurApplications;

	typedef struct
	{
		int 		type;
		QString 	tagId;
		QByteArray 	tagIdBytes;

		bool 		hasAntenna;
		uchar		antennaId;

		bool 		hasRSSI;
		QByteArray	rssiPercent;

		bool 		hasReadFrequency;
		ulong		readFrequency;

		bool 		hasMemory;
		uchar 		memBank;
		ushort 		memAddr;
		QByteArray	memData;

		bool 		hasTrigger;
		int			triggerSourceId;
		QString		triggerSource;

		bool 		hasHandle;
		QByteArray 	handle;

		bool 		hasState;
		ushort 		state;
		QString 	stateName;

		bool 		hasBattery;
		uchar 		battery;

		bool 		hasPC;
		QByteArray	pc;

        bool 		hasRN16;
        QByteArray	rn16;

        bool 		hasNxpBrandId;
        QByteArray	nxpBrandId;

        bool 		hasMessageId;
		uchar 		messageId;

		bool 		hasApplicationInfo;
		QByteArray 	applicationInfo;
	} TagReadEvent;

	bool isPUR(const ulong readerType);
	bool isAUR(const ulong readerType);

    ReaderModule  getReaderModule(const ulong readerType);
    ulong  getApplicationId(const ulong readerType);
	ulong  readerTypeWithApplication (const ulong readerType, const ulong application);

	QString readerTypeToString(const ulong readerType);
	QString readerSerialToString(const ulong readerSerial);
	QString hardwareRevisionToString(const ulong hardwareRevision);
	QString softwareRevisionToString(const ulong softwareRevision);
	QString bootloaderRevisionToString(const ulong bootloaderRevision);

	QString applicationToString(const ulong readerType);

	ulong  readerCaps 			( const ulong readerType, const ulong hardwareRevision, const ulong softwareRevision, const ReaderSystem currentSystem );
	ulong  tagFunctionCaps	 	( const ulong readerType, const ulong hardwareRevision, const ulong softwareRevision, const ReaderSystem currentSystem );

	QMap<uint,QString> 		availableMemoryBanks(TagType tagType);
};

Q_DECLARE_METATYPE(QrfeGlobal::TagReadEvent)

class __init_QrfeReaderInterfaceGlobal
{
public:
	__init_QrfeReaderInterfaceGlobal();
};



#endif /* QRFEREADERINTERFACEGLOBAL_H_ */
